<?php
if (!defined('ABSPATH')) exit;

class Audit_Display {
    public static function render_main_page() {
        if (!is_user_logged_in()) {
            wp_die(__('You must be logged in to view this page.'));
        }

        $current_user = wp_get_current_user();
        $user_id = $current_user->ID;

        echo '<div class="wrap"><h1>Audit Trail Logs</h1>';
        self::render_login_history_table($user_id);
        echo '<hr>';
        self::render_activity_log_table($user_id);
        echo '</div>';
    }

    private static function render_login_history_table($user_id) {
        global $wpdb;
        $table_name = $wpdb->prefix . 'audit_trail_login_history';

        $limit = min(max(intval($_GET['limit'] ?? 15), 15), 30);
        $paged = max(1, intval($_GET['paged'] ?? 1));
        $offset = ($paged - 1) * $limit;

        $total = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE user_id = %d", $user_id));
        $rows = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE user_id = %d ORDER BY login_time DESC LIMIT %d OFFSET %d", $user_id, $limit, $offset));

        echo '<h2>Login History</h2>';
        echo '<table class="widefat striped"><thead><tr>';
        echo '<th>Sr No</th><th>User ID</th><th>User Name</th><th>IP Address</th><th>Browser</th><th>Login Time</th><th>Logout Time</th><th>Status</th><th>Message</th>';
        echo '</tr></thead><tbody>';

        $sr = $offset + 1;
        foreach ($rows as $row) {
            echo "<tr>
                <td>{$sr}</td>
                <td>{$row->user_id}</td>
                <td>{$row->username}</td>
                <td>{$row->ip_address}</td>
                <td>" . esc_html(wp_trim_words($row->browser, 10)) . "</td>
                <td>" . esc_html(date_i18n('Y-m-d g:i a', strtotime($row->login_time))) . "</td>
                <td>" . esc_html($row->logout_time ? date_i18n('Y-m-d g:i a', strtotime($row->logout_time)) : '-') . "</td>
                <td>{$row->status}</td>
                <td>{$row->message}</td>
              </tr>";
            $sr++;
        }

        echo '</tbody></table>';
        self::render_pagination($paged, $limit, $total, 'limit', 'paged');
    }

    private static function render_activity_log_table($user_id) {
        global $wpdb;
        $table_name = $wpdb->prefix . 'audit_trail_user_activities';

        $limit = min(max(intval($_GET['limit_act'] ?? 15), 15), 30);
        $paged = max(1, intval($_GET['paged_act'] ?? 1));
        $offset = ($paged - 1) * $limit;

        $total = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE user_id = %d", $user_id));
        $rows = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE user_id = %d ORDER BY datetime DESC LIMIT %d OFFSET %d", $user_id, $limit, $offset));

        echo '<h2>User Activity Logs</h2>';
        echo '<table class="widefat striped"><thead><tr>';
        echo '<th>Sr No</th><th>ID</th><th>User ID</th><th>User Role</th><th>Date & Time</th><th>Activity</th><th>Type</th><th>Description</th>';
        echo '</tr></thead><tbody>';

        $sr = $offset + 1;
        foreach ($rows as $row) {
            echo "<tr>
                <td>{$sr}</td>
                <td>{$row->id}</td>
                <td>{$row->user_id}</td>
                <td>{$row->role}</td>
                <td>" . esc_html(date_i18n('Y-m-d g:i a', strtotime($row->datetime))) . "</td>
                <td>{$row->activity}</td>
                <td>{$row->type}</td>
                <td>{$row->description}</td>
              </tr>";
            $sr++;
        }

        echo '</tbody></table>';
        self::render_pagination($paged, $limit, $total, 'limit_act', 'paged_act');
    }

    private static function render_pagination($paged, $limit, $total, $limit_key, $paged_key) {
        $total_pages = ceil($total / $limit);
        if ($total_pages <= 1) return;

        echo '<div class="tablenav"><div class="tablenav-pages">';
        for ($i = 1; $i <= $total_pages; $i++) {
            $url = add_query_arg([$paged_key => $i, $limit_key => $limit]);
            $current = $i === $paged ? ' class="current"' : '';
            echo "<a href='" . esc_url($url) . "'{$current}>$i</a> ";
        }
        echo '</div></div>';
    }
}
